<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DynamicFormField extends Model 
{

    protected $table = 'dynamic_form_fields';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('dynamic_form_id', 'name_ar', 'name_en', 'type', 'data', 'component');

    public function form()
    {
        return $this->belongsTo('App\Models\DynamicForm');
    }

    public function component()
    {
        return $this->morphTo();
    }

}